#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Sun Feb 18 16:31:12 2018

Root finding algorithm (bisection method)

@author: mischaknabenhans
"""
#%% 1) Define function whose roots have to be found
def f(x):
    return x**3-x-2

#%% 2) Auxiliary function
def sign(x):
    if x<0:
        return -1
    else:
        return 1

#%% 3) Implement the root finder algorithm

def RootFinder(f,a,b,tol,Nmax):
    N=1
    
    #Test if f(a) > 0 and f(b) < 0,
    
    while N<=Nmax:
        c = (a+b)/2.
        if (f(c) == 0 or (b-a)/2. < tol):
            print("Solution found in N=" + str(N) + " iteration steps.")
            return c
        else:
            N=N+1
            if sign(f(c)) == sign(f(a)):
                a=c
            else:
                b=c
    
    print("No solution found in "+str(Nmax)+" iterations.")
    return None

#%% 4) Execute root finder
a=1
b=2
tol=10**(-5)
Nmax = 20
    
root = RootFinder(f,a,b,tol,Nmax)

print("Root found: x0 = " + str(root))
print("Tolerance: tol =" + str(tol))
