#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Sun Feb 18 16:31:12 2018

Root finding algorithm (bisection method)

SYNOPSIS: python BisectionRootFinder2.py func a b tol Nmax

where 
	func is the function whose root shall be found
	a is the lower bound of the interval within which the root is suspected
	b is the upper bound of the interval within which the root is suspected
	tol is the tolerance accepted for the returned solution
	Nmax is the maximal number of iterations steps allowed 

@author: mischaknabenhans
"""
#%% 1) Import system module to allow for command line input
import sys


#%% 2) Auxiliary functions
def evalf(func,arg):
	x=arg
	return eval(func)

def sign(x):
    if x<0:
        return -1
    else:
        return 1

#%% 3) Implement the root finder algorithm

def RootFinder(f,a,b,tol,Nmax):
    N=1
    while N<=Nmax:
        c = (a+b)/2.
        if (evalf(f,c) == 0 or (b-a)/2. < tol):
            print("Solution found in N=" + str(N) + " iteration steps.")
            return c
        else:
            N=N+1
            if sign(evalf(f,c)) == sign(evalf(f,a)):
                a=c
            else:
                b=c
    
    print("No solution found in "+str(Nmax)+" iterations.")
    return None

#%% 4) Execute root finder
f=sys.argv[1]
a=float(sys.argv[2])
b=float(sys.argv[3])
tol=float(sys.argv[4])
Nmax = int(sys.argv[5])
    
root = RootFinder(f,a,b,tol,Nmax)

print("Root found: x0 = " + str(root))
print("Tolerance: tol =" + str(tol))
