# Feigenbaum diagram with Tkinter
# We use an image that is put into the canvas because drawing individual rectangles
# or points (lines of length 1) needs very much time (several minutes)!
# The image is redrawn automatically when the image data is updated.

import Tkinter as tk, threading, math, time, random

WINDOW_WIDTH = 400
WINDOW_HEIGHT = 400
    
def main():
    app = Application()
    app.master.title('Feigenbaum')
    task = Feigenbaum(app.canvas)
    app.task = task
    task.start()
    app.mainloop()
    task.isRunning = False
    task.join()
    print 'exit'
    
class Application(tk.Frame):
    def __init__(self, master=None):
        tk.Frame.__init__(self, master)
        self.alphaMinVar = tk.DoubleVar()
        self.alphaMinVar.set(3.0)
        self.alphaMaxVar = tk.DoubleVar()
        self.alphaMaxVar.set(4.0)
        self.grid()
        self.createWidgets()
        
    def createWidgets(self):
        self.canvas = tk.Canvas(self, bg="white", width=WINDOW_WIDTH, height=WINDOW_HEIGHT)
        self.canvas.grid(row=0, columnspan=4)
        self.labelAlphaMin = tk.Label(self, text="alpha min")
        self.labelAlphaMin.grid(row=1, column=0, sticky=tk.SW)
        self.entryAlphaMin = tk.Entry(self, textvariable=self.alphaMinVar)
        self.entryAlphaMin.grid(row=1, column=1, sticky=tk.SW)
        self.labelAlphaMax = tk.Label(self, text="alpha max")
        self.labelAlphaMax.grid(row=1, column=2, sticky=tk.SW)
        self.entryAlphaMax = tk.Entry(self, textvariable=self.alphaMaxVar)
        self.entryAlphaMax.grid(row=1, column=3, sticky=tk.SW)
        self.recalcButton = tk.Button(self, text='Recalculate', command=self.handleRecalcButton)
        self.recalcButton.grid(row=2, column=0, columnspan=2)
        self.quitButton = tk.Button(self, text='Quit', command=self.quit)
        self.quitButton.grid(row=2, column=3)
        
    def handleRecalcButton(self):
        self.task.alphaMin = self.alphaMinVar.get()
        self.task.alphaMax = self.alphaMaxVar.get()
        self.task.do_recalculate = True
        
        
class Feigenbaum(threading.Thread):
        
    N = WINDOW_WIDTH
    MAX_ITER = 200
    isRunning = True
    do_recalculate = True
    alphaMin = 3.0
    alphaMax = 4.0
        
    def __init__(self, canvas):
        threading.Thread.__init__(self)
        self.canvas = canvas
        
    def calculate(self, alphaMin, alphaMax, N, MAX_ITER):
        # Create an image and add it to the canvas. The image is redrawn when
        # the image data is updated later on.
        image = tk.PhotoImage(width=N, height=N)

        # NOTE: Store a reference to the image as an attribute of the widget
        # to avoid garbage collection!!!
        self.canvas.img = image
        self.canvas.create_image(N/2, N/2, image=image)   
        
        for x in range(N):
            alpha = alphaMin + x*(alphaMax - alphaMin)/N
            y = random.random()
            # iterate logistic equation
            for j in range(MAX_ITER): # initial transition
                y = alpha*y*(1 - y)
            for j in range(MAX_ITER): # plot values
                y = alpha*y*(1 - y)
                ys = int(WINDOW_HEIGHT*(0.999999999-y)) # ys should be at most WINDOW_HEIGHT-1
                image.put("#000000", (x, ys))
            if not self.isRunning:
                return
            
    def run(self):
        while self.isRunning:
            if self.do_recalculate == True:
                self.calculate(self.alphaMin, self.alphaMax, self.N, self.MAX_ITER)
                self.do_recalculate = False
            time.sleep(0.1)
        
if __name__ == '__main__':
    main()

