# Feigenbaum iteration diagram with Tkinter

import Tkinter as tk, threading, time, random

WINDOW_WIDTH = 400
WINDOW_HEIGHT = 400
    
def main():
    app = Application()
    app.master.title('Feigenbaum Iteration')
    task = Feigenbaum(app.canvas)
    app.task = task
    task.start()
    app.mainloop()
    task.isRunning = False
    task.join()
    print 'exit'
    
class Application(tk.Frame):
    def __init__(self, master=None):
        tk.Frame.__init__(self, master)
        self.alphaVar = tk.DoubleVar()
        self.alphaVar.set(3.5)
        self.iterVar = tk.IntVar()
        self.iterVar.set(10)
        self.grid()
        self.createWidgets()
        
    def createWidgets(self):
        self.canvas = tk.Canvas(self, bg="white", width=WINDOW_WIDTH, height=WINDOW_HEIGHT)
        self.canvas.grid(row=0, columnspan=4)
        self.labelAlpha = tk.Label(self, text="alpha")
        self.labelAlpha.grid(row=1, column=0, sticky=tk.SW)
        self.entryAlpha = tk.Entry(self, textvariable=self.alphaVar)
        self.entryAlpha.grid(row=1, column=1, sticky=tk.SW)
        self.labelIter = tk.Label(self, text="iterations")
        self.labelIter.grid(row=1, column=2, sticky=tk.SW)
        self.entryIter = tk.Entry(self, textvariable=self.iterVar)
        self.entryIter.grid(row=1, column=3, sticky=tk.SW)
        self.recalcButton = tk.Button(self, text='Recalculate', command=self.handleRecalcButton)
        self.recalcButton.grid(row=2, column=0, columnspan=2)
        self.quitButton = tk.Button(self, text='Quit', command=self.quit)
        self.quitButton.grid(row=2, column=2)
        
    def handleRecalcButton(self):
        self.task.alpha = self.alphaVar.get()
        self.task.iter = self.iterVar.get()
        self.task.do_recalculate = True
        
        
class Feigenbaum(threading.Thread):
        
    isRunning = True
    do_recalculate = True
    alpha = 3.5
    iter = 10
        
    def __init__(self, canvas):
        threading.Thread.__init__(self)
        self.canvas = canvas
        
    def calculate(self, alpha, iter):
        self.canvas.delete(tk.ALL)
        
        # draw parabola
        last_x, last_y = 0, 0
        for ix in range(WINDOW_WIDTH):
            x = float(ix)/WINDOW_WIDTH
            y = alpha*x*(1 - x)
            ys = int(WINDOW_HEIGHT*(1-y)) + 1
            self.canvas.create_line(last_x, last_y, ix, ys, fill='red', width=3)
            last_x, last_y = ix, ys
        
        # draw 45 degree line
        self.canvas.create_line(0, WINDOW_HEIGHT, WINDOW_WIDTH, 0, dash=(5,1), fill='#00cc00')
        
        # do some iterations
        x = random.random()
        yold = 0
        for i in range(iter):
            y = alpha*x*(1 - x)
            xs = int(WINDOW_WIDTH*x)
            ysold = int(WINDOW_HEIGHT*(1-yold)) + 1
            ys = int(WINDOW_HEIGHT*(1-y)) + 1
            self.canvas.create_line(xs, ysold, xs, ys)
            if i < iter-1:
                self.canvas.create_line(xs, ys, int(WINDOW_WIDTH*y), ys)
            yold = y
            x = y
            
    def run(self):
        while self.isRunning:
            if self.do_recalculate == True:
                self.calculate(self.alpha, self.iter)
                self.do_recalculate = False
            time.sleep(0.1)
        
if __name__ == '__main__':
    main()

