#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Sun Mar 11 14:29:01 2018

@author: mischaknabenhans
"""

#%% Import modules
import numpy as np
import matplotlib.pyplot as plt

#%% Auxiliary equations

# Hamiltonian of harmonic oscillator
def HO_Hamiltonian(q,p):
    return 0.5*p**2-np.cos(q)

# Foreward Euler
def fwEuler(q,p,h):
    return [q+h*p, p-h*q]   # Hamilton equations

# leap frog
def leapFrog(q,p,h):
    q_half = q + 0.5*h*p
    p_new  = p - h*np.sin(q_half)
    q_new  = q_half + 0.5*h*p_new
    
    return [q_new, p_new]

def SolveHamiltonEvolution(q,p,h,method):
    qList = [q]
    pList = [p]
    EList = [2*HO_Hamiltonian(q,p)]

    # Compute phase space evolution
    for c in range(nSteps):
        if method=='Euler':
            [q, p] = fwEuler(q,p,h)
        elif method=='LeapFrog':
            [q, p] = leapFrog(q,p,h)
        qList.append(q)
        pList.append(p)
        EList.append(2*HO_Hamiltonian(q,p))
    
    qvec = np.array(qList)
    pvec = np.array(pList)
    Evec = np.array(EList)

    return [qvec, pvec, Evec]
#%% Main
    
t_ini = 0
t_fin = 20
nSteps = int(1e3)

h = float(t_fin-t_ini)/nSteps
tvec = np.linspace(t_ini, t_fin, nSteps+1) #the boundaries are included

# Initial conditions
q_lf_Arr = []
p_lf_Arr = []
E_lf_Arr = []

# Compute phase space evolution for different energy level
Elevels = np.linspace(1,5,5)
E_label = map(str, Elevels)
for E in Elevels:
    q = 1
    p = np.sqrt(E/0.5-q**2)


    [qvec_lf, pvec_lf, Evec_lf]=SolveHamiltonEvolution(q,p,h,'LeapFrog')

    q_lf_Arr.append(qvec_lf)
    p_lf_Arr.append(pvec_lf)
    E_lf_Arr.append(Evec_lf)

# Compute contours
q = np.linspace(-10, 10, 61)
p = np.linspace(-5, 5, 61)

Q,P = np.meshgrid(q, p)
H = HO_Hamiltonian(Q,P)

# Plot
Fig1, axs = plt.subplots(1,2,sharey=True)
ax = axs[0]
# Phase space plot
for i in range(len(Elevels)):
    ax.plot(q_lf_Arr[i],p_lf_Arr[i], label="E="+E_label[i])
ax.set_xlabel("q")
ax.set_ylabel("p")
ax.legend(loc="lower right")

ax = axs[1]
ax.contour(Q,P,H,40,cmap='inferno')
ax.set_xlabel("q")
tit = Fig1.tight_layout()
Fig1.show()



    