#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Sun Mar 11 15:01:46 2018

@author: mischaknabenhans
"""

#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Sun Mar 11 14:29:01 2018

@author: mischaknabenhans
"""

#%% Import modules
import numpy as np
import matplotlib.pyplot as plt

#%% Auxiliary equations

# Hamiltonian of harmonic oscillator
def HO_Hamiltonian(q,p):
    return 0.5*(q**2 + p**2)

# leap frog
def leapFrog(q,p,h):
    q_half = q + 0.5*h*p
    p_new  = p - h*q_half
    q_new  = q_half + 0.5*h*p_new
    
    return [q_new, p_new]

#%% Main
    
t_ini = 0
t_fin = 20
nSteps = int(1e3)

h = float(t_fin-t_ini)/nSteps
tvec = np.linspace(t_ini, t_fin, nSteps+1) #the boundaries are included

# Initial conditions
q = 1
p = 0

qList = [q]
pList = [p]
EList = [2*HO_Hamiltonian(q,p)]

# Compute phase space evolution
for c in range(nSteps):
    [q, p] = leapFrog(q,p,h)
    qList.append(q)
    pList.append(p)
    EList.append(2*HO_Hamiltonian(q,p))
    
qvec = np.array(qList)
pvec = np.array(pList)
Evec = np.array(EList)

# Plot
Fig1, axs = plt.subplots(1,2)

# Position, momentum & energy vs time
ax = axs[0]
ax.plot(tvec, qvec, label="q(t)")
ax.plot(tvec, pvec, label="p(t)")
ax.plot(tvec, Evec, label="E(t)")
ax.set_xlabel("t")
ax.legend(loc="best")

# Phase space plot
ax = axs[1]
ax.plot(qvec,pvec)
ax.set_xlabel("q")
ax.set_ylabel("p")

Fig1.tight_layout()
Fig1.show()




    