# -*- coding: utf-8 -*-
"""
Created on Sun Apr  1 13:53:34 2018

@author: sts
"""

import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation

fig, ax = plt.subplots()
xdata, ydata = [], []
ln, = plt.plot([], [], 'ro', animated=True)

p = 0
q = 1
h = 0.1
nmax = 100
tmax = nmax*h

def dgl(p,q):
    """Harmonic oscillator"""
    dp = -q
    dq = p
    return (dp, dq)

def leapFrog(p0, q0, h):
    q12 = q0 + 0.5*h*p0
    dp, dq = dgl(p0, q12)
    p1 = p0 + h*dp
    q1 = q12 + 0.5*h*p1
    return (p1, q1)

def euler(p, q, h):
    dp, dq = dgl(p, q)
    p += h*dp
    q += h*dq
    return (p, q)
    
def init():
    ax.set_xlim(-2.0, 2.0)
    ax.set_ylim(-2.0, 2.0)
    return ln,

def update(frame):
    global p,q
    #p, q = leapFrog(p, q, h)
    p, q = euler(p, q, h)
    xdata.append(q)
    ydata.append(p)
    ln.set_data(xdata, ydata)
    return ln,

ani = FuncAnimation(fig, update, frames=np.linspace(0, tmax, nmax),
                    init_func=init, blit=True, interval=30)
plt.show()