# This module defines various color maps and utility functions

import math

def rainbow_colormap(value):
    """Rainbow color map for values in the range [0,1]."""
    if 0 < value and value <= 0.2:
        rr = 255
        gg = math.trunc(255*5*value)
        bb = 0
    elif 0.2 < value and value <= 0.4:
        rr = math.trunc(255*(1 - 5*(value - 0.2)))
        gg = 255
        bb = 0
    elif 0.4 < value and value <= 0.6:
        rr = 0
        gg = 255
        bb = math.trunc(255*(5*(value - 0.4)))
    elif 0.6 < value and value <= 0.8:
        rr = 0
        gg = math.trunc(255*(1 - 5*(value - 0.6)))
        bb = 255
    elif 0.8 < value and value <= 1.0:
        rr = math.trunc(255*(5*(value - 0.8)))
        gg = 0
        bb = 255
    else:
        rr, gg, bb = 0, 0, 0
        
    return [rr, gg, bb]
    
def iron_colormap(value):
    """Iron color map for values in the range [0,1]."""
    if 0 < value and value <= 0.2:
        rr = 0
        gg = 0
        bb = math.trunc(255*5*value)
    elif 0.2 < value and value <= 0.4:
        rr = math.trunc(255*5*(value - 0.2))
        gg = 0
        bb = 255
    elif 0.4 < value and value <= 0.6:
        rr = 255
        gg = 0
        bb = math.trunc(255*(1 - 5*(value - 0.4)))
    elif 0.6 < value and value <= 0.8:
        rr = 255
        gg = math.trunc(255*5*(value - 0.6))
        bb = 0
    elif 0.8 < value and value <= 1.0:
        rr = 255
        gg = 255
        bb = math.trunc(255*(5*(value - 0.8)))
    else:
        rr, gg, bb = 0, 0, 0
        
    return [rr, gg, bb]
    
def to_string(rgb):
    """Converts a list of r,g,b values to a string of the form '#rrggbb'."""
    return "#{0:02x}{1:02x}{2:02x}".format(rgb[0], rgb[1], rgb[2])
