#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
Created on Mon Feb 26 13:00:02 2018

@author: mischaknabenhans
"""

#%% Load modules
import numpy as np
import Tkinter as tk
import threading as thr
import time, sys

#%% The Kepler equation

# M = E - e*sin(E)

# e = eccentricity
# E = eccentric anomaly
# M = average anomaly ( M = 2pi/T, where T = period )

# formulate Kepler's equation as root finding problem:
def KeplerFunc(E,e,M):
    return E-e*np.sin(E)-M

def dKeplerFunc(e,E):
    return 1-e*np.cos(E)


#%% Coordinate rescaling

def RescPhys2Img(x,y,pars):
       
    u=160*(x/((1-pars.e)*pars.a)+pars.a/3)
    v=120*(-y/pars.b+pars.b/4)   # the sign comes from the fact that tkinter 
                                # windows have their y-axis upside down
    
    return [u,v] 
        

#%% Newton-Raphson algorithm
    
def findE(planet,tol,minslope,Nmax,verbose=False):
    N=1
    
    E=planet.E
    e=planet.e
    M=planet.M
    
    while (N<Nmax):
        if verbose:
            print("N=%d\tE=%f" % (N,E))
            
        slope = dKeplerFunc(e,E)
        
        if abs(slope) < minslope:
            print("Divergence!")
            return None
        
        y = KeplerFunc(E,e,M)
        E = E - y/slope

        if(abs(KeplerFunc(E,e,M))<=tol):
            if verbose:
                print("Solution found in %d steps with tolerance %0.15f\n" %(N+1,tol))
            return E
        
        N += 1
    
    print("No solution found!\n")    
    return None

#%% Define Classes
class Kepler:
    def __init__(self,M,E,e,a):
        self.M=M
        self.E=E
        self.e=e
        self.a=a
    
    def minax(self):
        self.b = self.a*np.sqrt(1-self.e)
    
    def position(self):
        x = self.a*np.cos(self.E) - self.a*self.e
        y = self.b*np.sin(self.E)
        return [x,y]
    
class Draw(thr.Thread):

    def __init__(self, canvas):
        thr.Thread.__init__(self)
        self.canvas = canvas

    def run(self):
        e = 0.3
        a = 10           # in [AU]
        M0 = 0
        E0 = 0
        
        myPlanet = Kepler(M0,E0,e,a)
        
        T = 1           # in [yrs] 
        
        PosData = []
        
        myPlanet.minax()
        
        # Place the Sun
        xF = myPlanet.e*myPlanet.a
        yF = 0.0
        [uF,vF]=RescPhys2Img(xF,yF,myPlanet)
        Fcoords = uF-10, vF-10, uF+10, vF+10
        self.canvas.create_oval(Fcoords, fill="yellow")
        
        for t in np.linspace(0,T,100):
            myPlanet.M = 2*np.pi*(t/T)
            
            myPlanet.E = findE(myPlanet,1e-10,1e-5,50, False)

            #myPlanet.minax()
            
            x = myPlanet.position()[0]
            y = myPlanet.position()[1]
            
            #print(x,y)
            PosData.append([x,y])
            
            [u,v]=RescPhys2Img(x,y,myPlanet)
            print(u,v)
            
            coords = u - 2, v - 2, u + 2, v + 2
            self.canvas.create_oval(coords, fill="white")
            time.sleep(0.1)      
    
        #np.savetxt('Kepler.dat',PosData)
#%% Graphics
#def main():
top = tk.Tk()    
canvas = tk.Canvas(top, bg="black", width=800, height=600)
canvas.pack()
    
task = Draw(canvas)
task.start()
    
top.mainloop()
task.join()
print('exit')
sys.exit(0)
    
#if __name__ == '__main__':
#    main()
