#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sat Feb 24 16:56:18 2018

@author: mischaknabenhans
"""
import numpy as np

#%% Solving the non-linear equation 

def f(x):
#    return x**2-1       # easy --> works!
#    return x**3-x -1    # Alternation if x_start=1 and divergenceif x_start=0.5
                        # works for x_start = 0.9
	return 1/np.sqrt(x)-x

def df(f,x,h):

#    return 2*x
    return (f(x+0.5*h)-f(x-0.5*h))/h


#%% Newton-Raphson algorithm
    
def NewtonRaphson(f,x,tol,minslope,Nmax, verbose=False):
    N=0
    h=1e-5

    while (N<Nmax):
        if verbose:
            print("N=%d\tx=%f" % (N,x))
            
        slope = df(f,x,h)
        
        if abs(slope) < minslope:
            print("Divergence!")
            return None
        
        y = f(x)
        x = x - y/slope

        if(abs(f(x))<=tol):
            print("Solution found in %d steps with tolerance %0.15f\n" %(N+1,tol))
            return x
        
        N += 1
    
    print("No solution found!\n")    
    return None

#%% Main function

res = NewtonRaphson(f,0.9,1e-10,1e-5,50, True)
if (res != None):
    print("x0 = %2.16f\n" % res)
