#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sat Feb 24 16:56:18 2018

@author: mischaknabenhans
"""
#%% Solving the non-linear equation 

def df(xx,yy,i):
    return (yy[i+1]-yy[i-1])/(xx[i+1]-xx[i-1])

#%% Newton-Raphson algorithm
    
def NewtonRaphson(xx,yy,x,tol,minslope,Nmax, verbose=False):
    N=0
 
    while (N<Nmax):
        x = xx[abs(xx-x)==min(abs(xx-x))][0] #shift from arbitrary xstart to an x value that is actually on the grid
        indx = np.where(xx==x)[0][0] #np.where outputs a tuple of arrays
   
        if verbose:
            print("N=%d\tx=%f" % (N,x))
            
        slope = df(xx,yy,indx)
        
        if abs(slope) < minslope:
            print("Divergence!")
            return None
        
        y = yy[indx]
        x = x - y/slope
        
        if(abs(y)<=tol):
            print("Solution found in %d steps with tolerance %0.15f\n" %(N+1,tol))
            return x
        
        N += 1
    
    print("No solution found!\n")    
    return None

#%% Main function

# Import modules
import numpy as np

# Read in data
print("Reading data...")
x,y = np.loadtxt('Input_Data.fine.bin',unpack=True)

print("Working out solution...")
res = NewtonRaphson(x,y,0.9,1e-5,1e-5,50, False)
if (res != None):
    print("x0 = %2.16f\n" % res)
